/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Vector;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class NXTClient
implements PlayerListener {
    private DataOutputStream out = null;
    private DataInputStream in = null;
    public boolean run = true;
    private boolean hasshowInfo = false;
    public boolean isPlaySound = false;
    private boolean upLoadPrg = true;
    private boolean isTakingPhoto = false;
    private Player p = null;
    public static byte[] startPr1Cmd = new byte[]{22, 0, -128, 0, 100, 46, 114, 120, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static byte[] stopCurrentPrCmd = new byte[]{2, 0, -128, 1};
    public static byte[] startMotorsACmd = new byte[]{12, 0, -128, 4, 0, 100, 7, 0, 0, 32, 0, 0, 0, 0};
    public static byte[] stopAllMotorsCmd = new byte[]{12, 0, -128, 4, -1, 0, 1, 0, 0, 32, 0, 0, 0, 0};
    public static byte[] ResetMotorPosition = new byte[]{4, 0, -128, 10, 0, 1};
    public static byte[] getPinStatus = new byte[]{5, 0, 0, 19, 10, 0, 1};
    public static byte[] closeHandle = new byte[]{3, 0, 2, -124, 0};
    private byte[] getFirstPrgname = new byte[]{22, 0, 1, -122, 42, 46, 114, 120, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int DATASIZE = 26;
    public static byte HearderBYTE = (byte)28;
    public static byte motorFirst = 1;
    public static byte motorNext = (byte)2;
    public static byte REGULATION_MODE_MOTOR_SYNC = (byte)2;
    public static byte[] PPMsgNoReply = new byte[]{9, 0, -128, 9, 1, 5, 1, 0, 0, 0, 0};
    public Vector nxtFiles = null;
    public Vector debugInfo = null;
    public static String BTerrorString = "Lost connection with NXT. Please re-connect.";
    public static String GetProNamesString = "Retrieving program names\u2026";

    public NXTClient() {
        this.setupFilePlayer();
    }

    public void startService(ServiceRecord r) {
        try {
            String url = r.getConnectionURL(0, false);
            StreamConnection con = (StreamConnection)Connector.open((String)url);
            this.in = con.openDataInputStream();
            this.out = con.openDataOutputStream();
            String name = r.getHostDevice().getFriendlyName(true);
            if (name == null) {
                name = "";
            }
            this.FireCommand(stopCurrentPrCmd);
            NXTmobile.showInfoStringOnCurrentUI(name, "Connected to NXT:");
            Thread.currentThread();
            Thread.sleep(1500L);
            NXTmobile.showInfoStringOnCurrentUI("", GetProNamesString);
            Thread.currentThread();
            Thread.sleep(1500L);
            this.nxtFiles = new Vector();
            this.upLoadPrg = true;
            while (this.run) {
                try {
                    if (this.upLoadPrg) {
                        this.findFirsAndNextProgramFunction();
                        this.upLoadPrg = false;
                        NXTmobile.ChanceProgramgState(2);
                    }
                }
                catch (Exception e) {
                    NXTmobile.inFoBox(BTerrorString);
                    this.run = false;
                }
                try {
                    this.pullUseData();
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception e) {
                    NXTmobile.inFoBox(BTerrorString);
                    this.run = false;
                }
            }
            this.out.close();
            this.in.close();
            con.close();
            con = null;
            this.out = null;
            this.in = null;
            System.gc();
        }
        catch (Exception e) {
            NXTmobile.ChanceProgramgState(2);
            this.run = false;
            NXTmobile.inFoBox(BTerrorString);
        }
    }

    private void pullUseData() {
        block11: {
            try {
                this.FireCommand(getPinStatus);
                byte[] data = new byte[66];
                this.in.read(data, 0, data.length);
                if (data.length != 66) break block11;
                System.gc();
                if (data[7] == 1 && !this.isTakingPhoto) {
                    if (NXTmobile.VideoControlPlatform) {
                        NXTmobile.inFoBox("Msg: Take Photo!");
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        this.isTakingPhoto = true;
                        NXTmobile.host.TakePhotoNow();
                    } else {
                        this.isTakingPhoto = false;
                        NXTmobile.inFoBox("Msg: Taking photos is not supported on this phone!");
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    byte k = 0;
                    this.whilePress(k);
                    return;
                }
                if (data[7] == 2) {
                    if (NXTmobile.SoundPlayPlatform) {
                        NXTmobile.inFoBox("Msg: Play Sound");
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        this.playfile();
                    } else {
                        NXTmobile.inFoBox("Msg: Playing sound is not supported on this phone!");
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    byte k = 0;
                    this.whilePress(k);
                    return;
                }
                if (data[7] <= 0) break block11;
                try {
                    String info = new String(data, 7, data.length - 7);
                    if (info.compareTo("") != 0) {
                        NXTmobile.inFoBox("Msg: " + info.trim());
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        this.logData(info);
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void logData(String data) {
        if (this.debugInfo == null) {
            this.debugInfo = new Vector();
        }
        try {
            Calendar rightNow = Calendar.getInstance();
            String timedate = "" + rightNow.get(10) + ":" + rightNow.get(12) + ":" + rightNow.get(13);
            this.debugInfo.addElement(timedate + " " + data.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void whilePress(byte cmd) {
        boolean wait = true;
        while (wait) {
            try {
                this.FireCommand(getPinStatus);
                byte[] data = new byte[66];
                this.in.read(data);
                if (data.length == 66 && data[7] == cmd) {
                    wait = false;
                    this.isTakingPhoto = false;
                }
                Thread.currentThread();
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
    }

    public void sendMSG(byte code) {
        try {
            NXTClient.PPMsgNoReply[6] = code;
            this.FireCommand(PPMsgNoReply);
            NXTmobile.showInfoStringOnCurrentUI("", "Sending MSG: " + code);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playerUpdate(Player player, String event, Object eventData) {
        try {
            NXTClient nXTClient = this;
            synchronized (nXTClient) {
                if (event.equals("endOfMedia")) {
                    this.isPlaySound = false;
                    if (this.p != null) {
                        this.p.stop();
                    }
                }
            }
        }
        catch (Exception dd) {
            // empty catch block
        }
    }

    private void setupFilePlayer() {
        try {
            this.p = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/jb.mid"), (String)"audio/midi");
            this.p.addPlayerListener((PlayerListener)this);
        }
        catch (Exception pe) {
            NXTmobile.SoundPlayPlatform = false;
        }
    }

    public synchronized void playfile() {
        try {
            if (this.isPlaySound || this.p == null || this.p.getState() == 400) {
                return;
            }
            this.isPlaySound = true;
            this.p.start();
        }
        catch (Exception pe) {
            NXTmobile.inFoBox(pe.toString());
        }
    }

    public synchronized void FireCommand(byte[] cmd) {
        if (this.out != null) {
            try {
                this.out.write(cmd, 0, cmd.length);
                this.out.flush();
            }
            catch (Exception e) {
                NXTmobile.inFoBox(BTerrorString);
                this.run = false;
            }
        }
    }

    private byte findFirst() {
        byte[] filedata = new byte[26];
        try {
            this.out.write(this.getFirstPrgname, 0, this.getFirstPrgname.length);
            this.out.flush();
            while (this.in.read() != HearderBYTE) {
            }
            this.in.read();
            this.in.read(filedata, 0, filedata.length);
            try {
                String filename = new String(filedata, 4, 18).trim();
                if (filename.compareTo("") != 0) {
                    this.nxtFiles.addElement(filename);
                    NXTmobile.showInfoStringOnCurrentUI(filename, GetProNamesString);
                }
            }
            catch (Exception c) {
                NXTmobile.inFoBox(BTerrorString);
            }
            NXTClient.closeHandle[4] = filedata[3];
            this.out.write(closeHandle, 0, closeHandle.length);
            this.out.flush();
            byte[] feedback = new byte[4];
            this.in.read(feedback, 0, feedback.length);
        }
        catch (Exception c) {
            NXTmobile.inFoBox(BTerrorString);
        }
        return filedata[3];
    }

    private void findFirsAndNextProgramFunction() {
        boolean morefilesToRead = true;
        try {
            byte handleToNext = this.findFirst();
            byte[] findnext = new byte[]{3, 0, 1, -121, handleToNext};
            while (morefilesToRead) {
                this.out.write(findnext, 0, findnext.length);
                this.out.flush();
                while (this.in.read() != HearderBYTE) {
                }
                this.in.read();
                byte[] filedata = new byte[26];
                this.in.read(filedata, 0, filedata.length);
                try {
                    String filename = new String(filedata, 4, 18).trim();
                    NXTmobile.showInfoStringOnCurrentUI(filename, GetProNamesString);
                    if (filename.compareTo("") != 0) {
                        this.nxtFiles.addElement(filename);
                    }
                }
                catch (Exception c) {
                    NXTmobile.inFoBox(BTerrorString);
                }
                if (filedata[2] != 0) {
                    morefilesToRead = false;
                    NXTmobile.showInfoStringOnCurrentUI("Completed", GetProNamesString);
                    Thread.currentThread();
                    Thread.sleep(1500L);
                } else {
                    findnext[4] = filedata[3];
                    NXTClient.closeHandle[4] = filedata[3];
                    this.out.write(closeHandle, 0, closeHandle.length);
                    this.out.flush();
                    byte[] feedback = new byte[4];
                    this.in.read(feedback, 0, feedback.length);
                }
                Thread.currentThread();
                Thread.sleep(300L);
            }
        }
        catch (Exception c) {
            morefilesToRead = false;
        }
    }

    public void StartThisPrg(String prgName) {
        try {
            NXTmobile.showInfoStringOnCurrentUI("", "Run: " + prgName);
            Thread.currentThread();
            Thread.sleep(1000L);
            byte[] startprg = new byte[24];
            startprg[0] = 22;
            startprg[1] = 0;
            startprg[2] = -128;
            startprg[3] = 0;
            char[] fileNameByte = prgName.toCharArray();
            int t = -1;
            while (++t < fileNameByte.length) {
                startprg[t + 4] = (byte)fileNameByte[t];
            }
            startprg[++t] = 114;
            startprg[++t] = 120;
            startprg[++t] = 101;
            while (++t < startprg.length) {
                startprg[t] = 0;
            }
            this.FireCommand(startprg);
            startprg = null;
            System.gc();
        }
        catch (Exception c) {
            NXTmobile.inFoBox("Bad program name! Rename program name!");
        }
    }
}

