/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;

public class NXTDiscoveryAgent
implements CommandListener {
    public static Command COMPLETED = new Command("COMPLETED", 1, 1);
    public static Command SELECTED = new Command("SELECTED", 1, 1);
    public static Command BACK = new Command("Main Menu", 2, 1);
    public static MIDlet host;
    public static CommandListener callback;
    public static NXTDiscoveryAgent instance;
    public static Display display;
    public static Vector devices;
    public static Vector deviceClasses;
    public static Vector services;
    public static int selectedDevice;
    private BTDiscoveryCanvas DiscoveryCanvas = null;
    public Listener currentLister = null;
    public int discoveryMode;
    public UUID[] serviceUUIDs = null;
    public int deviceReturnCode;
    public int serviceReturnCode;
    private NXTRemoteDeviceList remotedeviceui = null;
    private LocalDevice device;
    private DiscoveryAgent agent;
    private static final int ID_SERVICE_COMPLETED = 1;
    private static final int ID_DEVICE_COMPLETED = 2;
    private static final int ID_DEVICE_SELECTED = 3;

    public NXTDiscoveryAgent(MIDlet host, CommandListener listener, BTDiscoveryCanvas anicanvas) {
        NXTDiscoveryAgent.host = host;
        callback = listener;
        this.DiscoveryCanvas = anicanvas;
        instance = this;
    }

    public void startApp() {
        display = Display.getDisplay((MIDlet)host);
        this.remotedeviceui = new NXTRemoteDeviceList();
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void cancelInquiry() {
        if (this.currentLister == null) {
            return;
        }
        try {
            this.agent.cancelInquiry((DiscoveryListener)this.currentLister);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showListOfDevices() {
        if (this.currentLister == null) {
            return;
        }
        try {
            this.agent.cancelInquiry((DiscoveryListener)this.currentLister);
            this.remotedeviceui.showui();
            display.setCurrent((Displayable)this.remotedeviceui);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(String s) {
        System.out.println(s);
    }

    public Screen getUI() {
        return this.remotedeviceui;
    }

    public ServiceRecord[] getDiscoveredServices() {
        Object[] r = new ServiceRecord[services.size()];
        services.copyInto(r);
        return r;
    }

    public ServiceRecord getFirstDiscoveredService() {
        if (services.size() > 0) {
            return (ServiceRecord)services.elementAt(0);
        }
        return null;
    }

    public int getDeviceDiscoveryReturnCode() {
        return this.deviceReturnCode;
    }

    public int getServiceDiscoveryReturnCode() {
        return this.serviceReturnCode;
    }

    public RemoteDevice getSelectedDevice() {
        if (selectedDevice != -1) {
            return (RemoteDevice)devices.elementAt(selectedDevice);
        }
        return null;
    }

    public void startInquiry(int mode, UUID[] serviceUUIDs) {
        try {
            this.discoveryMode = mode;
            this.serviceUUIDs = serviceUUIDs;
            devices.removeAllElements();
            deviceClasses.removeAllElements();
            this.device = LocalDevice.getLocalDevice();
            this.device.setDiscoverable(10390323);
            this.agent = this.device.getDiscoveryAgent();
            this.currentLister = new Listener();
            boolean result = this.agent.startInquiry(mode, (DiscoveryListener)this.currentLister);
            if (this.DiscoveryCanvas != null) {
                this.DiscoveryCanvas.SetInfoString("", "Searching...");
            }
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        System.gc();
        if (d == this.remotedeviceui && c.getLabel().equals("Search")) {
            display.setCurrent((Displayable)this.DiscoveryCanvas);
            this.DiscoveryCanvas.reDoSearchAnimation();
            this.startInquiry(this.discoveryMode, this.serviceUUIDs);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Main Menu")) {
            callback.commandAction(BACK, (Displayable)this.remotedeviceui);
        } else if (d == this.remotedeviceui && c.getLabel().equals("Select")) {
            RemoteDevice remoteDevice = null;
            try {
                selectedDevice = this.remotedeviceui.getSelectedIndex();
                remoteDevice = (RemoteDevice)devices.elementAt(selectedDevice);
                services.removeAllElements();
            }
            catch (Exception ee) {
                NXTmobile.inFoBoxAndSetNextDisplayableUI("No NXT are found! You must make a new search", (Displayable)this.remotedeviceui);
                return;
            }
            try {
                this.agent.searchServices(null, this.serviceUUIDs, remoteDevice, (DiscoveryListener)new Listener());
                display.callSerially((Runnable)new Worker(3));
            }
            catch (BluetoothStateException ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        devices = new Vector();
        deviceClasses = new Vector();
        services = new Vector();
        selectedDevice = -1;
    }

    class Worker
    implements Runnable {
        int cmd = 0;

        public Worker(int cmd) {
            this.cmd = cmd;
        }

        public void run() {
            switch (this.cmd) {
                case 1: {
                    callback.commandAction(COMPLETED, (Displayable)NXTDiscoveryAgent.this.remotedeviceui);
                    break;
                }
                case 2: {
                    callback.commandAction(COMPLETED, (Displayable)NXTDiscoveryAgent.this.remotedeviceui);
                    break;
                }
                case 3: {
                    callback.commandAction(SELECTED, (Displayable)NXTDiscoveryAgent.this.remotedeviceui);
                    break;
                }
            }
        }
    }

    class Listener
    implements DiscoveryListener {
        Listener() {
        }

        public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            if (deviceClass.getMajorDeviceClass() == 2048 && deviceClass.getMinorDeviceClass() == 4) {
                devices.addElement(remoteDevice);
                deviceClasses.addElement(deviceClass);
                try {
                    if (NXTDiscoveryAgent.this.DiscoveryCanvas != null) {
                        NXTDiscoveryAgent.this.DiscoveryCanvas.SetInfoString("Found: " + remoteDevice.getFriendlyName(false), "Searching...");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void inquiryCompleted(int complete) {
            NXTDiscoveryAgent.this.deviceReturnCode = complete;
            ((NXTDiscoveryAgent)NXTDiscoveryAgent.this).DiscoveryCanvas.run = false;
            if (devices.size() == 0) {
                Alert alert = new Alert("Bluetooth", "No NXT device found! Turn on Bluetooth in your NXT and search Again", null, AlertType.INFO);
                alert.setTimeout(5000);
                NXTDiscoveryAgent.this.remotedeviceui.showui();
                display.setCurrent(alert, (Displayable)NXTDiscoveryAgent.this.remotedeviceui);
            } else {
                try {
                    if (NXTDiscoveryAgent.this.DiscoveryCanvas != null) {
                        NXTDiscoveryAgent.this.DiscoveryCanvas.SetInfoString("", "");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NXTDiscoveryAgent.this.remotedeviceui.showui();
                display.setCurrent((Displayable)NXTDiscoveryAgent.this.remotedeviceui);
            }
        }

        public void servicesDiscovered(int transId, ServiceRecord[] records) {
            for (int i = 0; i < records.length; ++i) {
                ServiceRecord record = records[i];
                services.addElement(record);
            }
        }

        public void serviceSearchCompleted(int transId, int complete) {
            NXTDiscoveryAgent.this.serviceReturnCode = complete;
            display.callSerially((Runnable)new Worker(1));
        }
    }
}

