/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class NXTMainMenu
extends GameCanvas
implements CommandListener {
    private Image background;
    private Image menubar;
    private Image infoImage = null;
    private int thisMenuState = 1;
    private boolean infoMode = false;
    private Command[] cmdarray = new Command[]{new Command("Exit", 1, 1), new Command("About", 1, 1), new Command("Connect to NXT", 1, 1)};

    public NXTMainMenu(boolean in) {
        super(false);
        try {
            this.setFullScreenMode(true);
            this.background = Image.createImage((String)"/A1-4.png");
            this.menubar = Image.createImage((String)"/Selected.png");
            this.loadCommands();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCommands() {
        try {
            int t = -1;
            while (++t < this.cmdarray.length) {
                this.addCommand(this.cmdarray[t]);
            }
            this.setCommandListener(this);
        }
        catch (Exception d) {
            NXTmobile.inFoBox(d.toString());
        }
    }

    public void paint(Graphics g) {
        try {
            g.setColor(201, 200, 192);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (!this.infoMode) {
                if (this.background != null) {
                    g.drawImage(this.background, NXTmobile.X_Pos, NXTmobile.Y_pos, 0);
                }
                this.drawThisMenuStare(g);
            } else if (this.infoImage != null) {
                g.drawImage(this.infoImage, NXTmobile.X_Pos, NXTmobile.Y_pos, 0);
            }
        }
        catch (Exception d) {
            NXTmobile.inFoBox(d.toString());
        }
    }

    private void removeCommands() {
        try {
            int t = -1;
            while (++t < this.cmdarray.length) {
                this.removeCommand(this.cmdarray[t]);
            }
        }
        catch (Exception d) {
            NXTmobile.inFoBox(d.toString());
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (NXTmobile.isTakingPhoto || NXTmobile.nxtClient.isPlaySound) {
            return;
        }
        if (c.getLabel().equals("Exit")) {
            NXTmobile.host.destroyApp(true);
            return;
        }
        if (c.getLabel().equals("About")) {
            this.infoMode = true;
            try {
                this.infoImage = NXTmobile.host.infomationImages[0];
            }
            catch (Exception e) {
                NXTmobile.inFoBox(e.toString());
            }
            this.removeCommands();
        } else {
            if (c.getLabel().equals("Connect to NXT")) {
                NXTmobile.ChanceProgramgState(1);
                return;
            }
            if (c.getLabel().equals("Back")) {
                this.infoMode = false;
            }
        }
        this.repaint();
    }

    private void drawThisMenuStare(Graphics g) {
        if (this.thisMenuState > 4 || this.thisMenuState < 1) {
            this.thisMenuState = 1;
        }
        switch (this.thisMenuState) {
            case 1: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 5 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
            case 2: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 33 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
            case 3: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 61 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
            case 4: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 89 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        try {
            if (NXTmobile.isTakingPhoto || NXTmobile.nxtClient.isPlaySound) {
                return;
            }
            if (keyCode == NXTmobile.keyEventRight && this.infoMode || keyCode == NXTmobile.SonyBackKey && this.infoMode) {
                this.infoMode = false;
                this.loadCommands();
                this.repaint();
                return;
            }
            if (keyCode != NXTmobile.keyEventRight && this.infoMode) {
                return;
            }
            switch (this.getGameAction(keyCode)) {
                case 6: {
                    ++this.thisMenuState;
                    break;
                }
                case 1: {
                    --this.thisMenuState;
                    break;
                }
                case 8: {
                    NXTmobile.ChanceProgramgState(this.thisMenuState + 2);
                    break;
                }
            }
            this.repaint();
        }
        catch (Exception c) {
            NXTmobile.inFoBoxAndSetNextDisplayableUI(c.toString(), (Displayable)this);
        }
    }
}

