/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class NXTDataCanvas
extends GameCanvas
implements CommandListener {
    private Image background;
    private Image menubar;
    private Image infoImage = null;
    private int thisMenuState = 1;
    private boolean infoMode = false;
    private Command[] cmdarray = new Command[]{new Command("Exit", 1, 1), new Command("Main Menu", 7, 1)};

    public NXTDataCanvas(boolean in) {
        super(false);
        try {
            this.setFullScreenMode(true);
            this.background = Image.createImage((String)"/CA3.png");
            this.menubar = Image.createImage((String)"/Selected.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCommands() {
        int t = -1;
        while (++t < this.cmdarray.length) {
            this.addCommand(this.cmdarray[t]);
        }
        this.setCommandListener(this);
    }

    public void paint(Graphics g) {
        g.setColor(201, 200, 192);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.infoMode) {
            if (this.background != null) {
                g.drawImage(this.background, NXTmobile.X_Pos, NXTmobile.Y_pos, 0);
            }
            this.drawThisMenuStare(g);
        } else if (this.infoImage != null) {
            g.drawImage(this.infoImage, NXTmobile.X_Pos, NXTmobile.Y_pos, 0);
        }
    }

    private void removeCommands() {
        int t = -1;
        while (++t < this.cmdarray.length) {
            this.removeCommand(this.cmdarray[t]);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c.getLabel().equals("Exit")) {
            NXTmobile.host.destroyApp(true);
            return;
        }
        if (c.getLabel().equals("Main Menu")) {
            if (NXTmobile.isTakingPhoto || NXTmobile.nxtClient.isPlaySound) {
                return;
            }
            NXTmobile.ChanceProgramgState(2);
            return;
        }
        if (c.getLabel().equals("Back")) {
            Display.getDisplay((MIDlet)NXTmobile.host).setCurrent((Displayable)this);
        }
        this.repaint();
    }

    private void drawThisMenuStare(Graphics g) {
        if (this.thisMenuState > 2 || this.thisMenuState < 1) {
            this.thisMenuState = 1;
        }
        switch (this.thisMenuState) {
            case 1: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 59 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
            case 2: {
                g.drawImage(this.menubar, 31 + (NXTmobile.X_Pos + NXTmobile.X_FactorPos), 87 + (NXTmobile.Y_pos + NXTmobile.Y_FactorPos), 0);
                break;
            }
        }
    }

    public void keyPressed(int keyCode) {
        try {
            if (keyCode == NXTmobile.SonyBackKey || keyCode == NXTmobile.keyEventRight) {
                NXTmobile.ChanceProgramgState(2);
                return;
            }
            switch (this.getGameAction(keyCode)) {
                case 6: {
                    ++this.thisMenuState;
                    break;
                }
                case 1: {
                    --this.thisMenuState;
                    break;
                }
                case 8: {
                    if (this.thisMenuState == 2) {
                        if (NXTmobile.nxtClient.debugInfo == null) {
                            NXTmobile.inFoBox("No data available");
                            break;
                        }
                        this.createDataForms(NXTmobile.nxtClient.debugInfo, "Collected Data");
                        break;
                    }
                    if (NXTmobile.remoteUI.imageArray == null) {
                        NXTmobile.inFoBox("No images available");
                        break;
                    }
                    this.createDataForms(NXTmobile.remoteUI.imageArray, NXTmobile.remoteUI.imageArray.size() + " Photo(s)");
                    break;
                }
            }
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createDataForms(Vector data, String title) {
        Form x = new Form(title);
        int t = -1;
        while (++t < data.size()) {
            if (this.thisMenuState == 2) {
                x.append((String)data.elementAt(t) + "\n\u0000");
                continue;
            }
            x.append((Image)data.elementAt(t));
        }
        x.addCommand(new Command("Back", 1, 1));
        x.setCommandListener((CommandListener)this);
        Display.getDisplay((MIDlet)NXTmobile.host).setCurrent((Displayable)x);
    }
}

